package ru.yandex.travel.grpc;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.stereotype.Service;

/**
 * Marks the annotated class to be registered as gRPC service bean.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Service
public @interface GrpcService {
    boolean authenticateService() default false;

    boolean authenticateUser() default false;

    boolean log() default true;

    boolean trace() default true;
}
