package ru.yandex.travel.grpc.interceptors;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;

public class DefaultTimeoutClientInterceptor implements ClientInterceptor {
    private Duration defaultTimout;

    public DefaultTimeoutClientInterceptor(Duration defaultTimout) {
        this.defaultTimout = defaultTimout;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        CallOptions newCallOptions = callOptions;
        if (callOptions.getDeadline() == null) {
            newCallOptions = callOptions.withDeadlineAfter(defaultTimout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return next.newCall(method, newCallOptions);
    }
}
