package ru.yandex.travel.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

import ru.yandex.travel.credentials.UserCredentials;

public class ExplicitUserCredentialsClientInterceptor implements ClientInterceptor {
    private final UserCredentials userCredentials;

    public ExplicitUserCredentialsClientInterceptor(UserCredentials userCredentials) {
        this.userCredentials = userCredentials;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method,
                                                               CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<>(next.newCall(method, callOptions)) {
            @Override
            protected void checkedStart(Listener<RespT> responseListener, Metadata headers) {
                UserCredentialsClientInterceptorHelper.passUserCredentials(userCredentials, headers);
                delegate().start(responseListener, headers);
            }
        };
    }
}
