package ru.yandex.travel.grpc.interceptors;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Optional;

import io.grpc.Metadata;
import io.grpc.internal.GrpcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptorCommons {
    private static final Logger logger = LoggerFactory.getLogger(LoggingInterceptorCommons.class);
    public static final Metadata.Key<Instant> METADATA_STARTED_AT = Metadata.Key.of("ya-grpc-started-at", new Metadata.AsciiMarshaller<Instant>() {
        @Override
        public String toAsciiString(Instant value) {
            return value.toString();
        }

        @Override
        public Instant parseAsciiString(String serialized) {
            try {
                return Instant.parse(serialized);
            } catch (DateTimeParseException e) {
                logger.info("Failed to parse 'ya-grpc-started-at' metadata", e);
                return null;
            }
        }
    });

    public static final Metadata.Key<String> METADATA_CALL_ID = Metadata.Key.of("ya-grpc-call-id", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> METADATA_FQDN = Metadata.Key.of("ya-grpc-fqdn", Metadata.ASCII_STRING_MARSHALLER);
    public static final Metadata.Key<String> METADATA_FORWARDED_FOR = Metadata.Key.of("ya-grpc-forwarded-for", Metadata.ASCII_STRING_MARSHALLER);

    public static Optional<Duration> getTimeoutDuration(Metadata headers) {
        Long timeoutNanos = headers.get(GrpcUtil.TIMEOUT_KEY);
        return Optional.ofNullable(timeoutNanos).map(Duration::ofNanos);
    }
}
