package ru.yandex.travel.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;

import ru.yandex.travel.tracing.GrpcMetadataInjectAdapter;

public class TracerClientInterceptor implements ClientInterceptor {
    private final Tracer tracer;

    public TracerClientInterceptor(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<>(next.newCall(method, callOptions)) {

            @Override
            protected void checkedStart(Listener<RespT> responseListener, Metadata headers) throws Exception {
                if (tracer.activeSpan() != null) {
                    Tags.SPAN_KIND.set(tracer.activeSpan(), Tags.SPAN_KIND_CLIENT);
                    Tags.HTTP_METHOD.set(tracer.activeSpan(), method.getFullMethodName());
                    tracer.inject(tracer.activeSpan().context(), Format.Builtin.HTTP_HEADERS, new GrpcMetadataInjectAdapter(headers));
                }
                delegate().start(responseListener, headers);
            }
        };
    }

}
