package ru.yandex.travel.grpc.interceptors;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;

import ru.yandex.travel.credentials.UserCredentials;

public class UserCredentialsClientInterceptor implements ClientInterceptor {
    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method,
                                                               CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<>(next.newCall(method, callOptions)) {
            @Override
            protected void checkedStart(Listener<RespT> responseListener, Metadata headers) throws Exception {
                UserCredentialsClientInterceptorHelper.passUserCredentials(UserCredentials.get(), headers);
                delegate().start(responseListener, headers);
            }
        };
    }
}
