package ru.yandex.travel.grpc.interceptors;

import io.grpc.Metadata;

import ru.yandex.travel.credentials.UserCredentials;

public class UserCredentialsClientInterceptorHelper {
    public static void passUserCredentials(UserCredentials userCredentials, Metadata headers) {
        if (userCredentials != null) {
            if (userCredentials.getYandexUid() != null) {
                headers.put(UserCredentialsInterceptorCommons.YANDEX_UID_HEADER, userCredentials.getYandexUid());
            }
            if (userCredentials.getLogin() != null) {
                headers.put(UserCredentialsInterceptorCommons.LOGIN_HEADER, userCredentials.getLogin());
            }
            if (userCredentials.getPassportId() != null) {
                headers.put(UserCredentialsInterceptorCommons.PASSPORT_ID_HEADER,
                        String.valueOf(userCredentials.getPassportId()));
            }
            if (userCredentials.getUserTicket() != null) {
                headers.put(UserCredentialsInterceptorCommons.USER_TICKET_HEADER, userCredentials.getUserTicket());
            }
            if (userCredentials.getSessionKey() != null) {
                headers.put(UserCredentialsInterceptorCommons.SESSION_KEY_HEADER, userCredentials.getSessionKey());
            }
            if (userCredentials.getUserIp() != null) {
                headers.put(UserCredentialsInterceptorCommons.USER_IP_HEADER, userCredentials.getUserIp());
            }
            headers.put(UserCredentialsInterceptorCommons.USER_IS_STAFF, userCredentials.isUserIsStaff());
            headers.put(UserCredentialsInterceptorCommons.USER_IS_PLUS, userCredentials.isUserIsPlus());
        }
    }
}
