package ru.yandex.travel.grpc.interceptors;

import com.google.common.base.Strings;
import io.grpc.Metadata;

import ru.yandex.travel.commons.http.CommonHttpHeaders;

public class UserCredentialsInterceptorCommons {

    public static final Metadata.AsciiMarshaller<Boolean> ASCII_BOOLEAN_MARSHALLER =
            new Metadata.AsciiMarshaller<>() {
                @Override
                public String toAsciiString(Boolean value) {
                    if (value != null) {
                        return value.toString();
                    } else {
                        return null;
                    }
                }

                @Override
                public Boolean parseAsciiString(String serialized) {
                    if (Strings.isNullOrEmpty(serialized)) {
                        return false;
                    } else {
                        return Boolean.parseBoolean(serialized);
                    }
                }
            };

    public static Metadata.Key<String> USER_TICKET_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.USER_TICKET.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<String> YANDEX_UID_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.YANDEX_UID.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<String> LOGIN_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.USER_LOGIN.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<String> PASSPORT_ID_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.PASSPORT_ID.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<String> SESSION_KEY_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.SESSION_KEY.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<String> USER_IP_HEADER =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.USER_IP.getHeader(),
                    Metadata.ASCII_STRING_MARSHALLER);
    public static Metadata.Key<Boolean> USER_IS_STAFF =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.USER_IS_STAFF.getHeader(),
                    ASCII_BOOLEAN_MARSHALLER);
    public static Metadata.Key<Boolean> USER_IS_PLUS =
            Metadata.Key.of(CommonHttpHeaders.HeaderType.USER_IS_PLUS.getHeader(),
                    ASCII_BOOLEAN_MARSHALLER);
}
