package ru.yandex.travel.http;

import java.io.IOException;
import java.util.EnumMap;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import io.grpc.Context;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import ru.yandex.travel.commons.http.CommonHttpHeaders;


@Slf4j
@RequiredArgsConstructor
public class CommonHttpHeadersServletFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest) request;
        var headers = new EnumMap<CommonHttpHeaders.HeaderType, String>(CommonHttpHeaders.HeaderType.class);
        for (CommonHttpHeaders.HeaderType ht: CommonHttpHeaders.HeaderType.values()) {
            String value = servletRequest.getHeader(ht.getHeader());
            if (value != null) {
                headers.put(ht, value);
            }
        }
        CommonHttpHeaders commonHttpHeaders = new CommonHttpHeaders(headers);
        try {
            Context.current().withValue(CommonHttpHeaders.KEY, commonHttpHeaders).call(
                    () -> {
                        chain.doFilter(request, response);
                        return null;
                    }
            );
        } catch (IOException | ServletException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void destroy() {
    }
}
