package ru.yandex.travel.http;

import java.io.IOException;

import javax.servlet.http.HttpServletResponse;

import org.springframework.web.util.ContentCachingResponseWrapper;

public class CustomContentCachingResponseWrapper extends ContentCachingResponseWrapper {

    private String errorReason;

    public CustomContentCachingResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        errorReason = msg;
        super.sendError(sc, msg);
    }

    public String getErrorReason() {
        return errorReason;
    }
}
