package ru.yandex.travel.http;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import ru.yandex.travel.PropertyUtils;
import ru.yandex.travel.tvm.TvmAutoConfiguration;
import ru.yandex.travel.tvm.TvmWrapper;

@Configuration
@ConditionalOnProperty("http-tvm-default.enabled")
@EnableConfigurationProperties(HttpTvmAutoConfiguration.DefaultHttpTvmProperties.class)
@RequiredArgsConstructor
@Slf4j
@AutoConfigureAfter(TvmAutoConfiguration.class)
public class HttpTvmAutoConfiguration implements WebMvcConfigurer {
    private final static Logger logger = LoggerFactory.getLogger(HttpTvmAutoConfiguration.class);
    private final DefaultHttpTvmProperties httpTvmProperties;

    private final TvmWrapper tvm2;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        TvmAuthenticationInterceptor interceptor = new TvmAuthenticationInterceptor(tvm2,
                PropertyUtils.stringToListOfStrings(httpTvmProperties.getAllowedConsumers()));
        log.info("Creating default HTTP tvm interceptor");
        registry.addInterceptor(interceptor).addPathPatterns("/**");
    }

    @ConfigurationProperties(value = "http-tvm-default", ignoreUnknownFields = false)
    static public class DefaultHttpTvmProperties extends BaseHttpTvmProperties {
    }
}
