package ru.yandex.travel.http;

import javax.servlet.DispatcherType;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class ReqAnsLoggingDispatcherServlet extends DispatcherServlet {
    @Override
    protected void doDispatch(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getDispatcherType() == DispatcherType.REQUEST) {
            ContentCachingRequestWrapper requestWrapper = new ContentCachingRequestWrapper(request);
            CustomContentCachingResponseWrapper responseWrapper = new CustomContentCachingResponseWrapper(response);
            super.doDispatch(requestWrapper, responseWrapper);
            if (!WebAsyncUtils.getAsyncManager(request).isConcurrentHandlingStarted()) {
                responseWrapper.copyBodyToResponse();
            }
        } else {
            super.doDispatch(request, response);
            if (response instanceof CustomContentCachingResponseWrapper) {
                ((CustomContentCachingResponseWrapper) response).copyBodyToResponse();
            }
        }
    }
}
