package ru.yandex.travel.http;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.common.collect.ImmutableSet;
import org.springframework.web.servlet.HandlerInterceptor;

import ru.yandex.travel.commons.http.CommonHttpHeaders;
import ru.yandex.travel.tvm.ServiceTicketCheck;
import ru.yandex.travel.tvm.TvmWrapper;

public class TvmAuthenticationInterceptor implements HandlerInterceptor {
    private final TvmWrapper tvm2;
    private final ImmutableSet<String> allowedConsumers;

    public TvmAuthenticationInterceptor(TvmWrapper tvm2, List<String> allowedConsumers) {
        this.tvm2 = tvm2;
        this.allowedConsumers = ImmutableSet.copyOf(allowedConsumers);
        tvm2.validateAliases(allowedConsumers);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String ticket = request.getHeader(CommonHttpHeaders.HeaderType.SERVICE_TICKET.getHeader());
        ServiceTicketCheck checkResult = tvm2.checkServiceTicket(ticket, allowedConsumers);
        if (!checkResult.isOk()) {
            response.sendError(HttpServletResponse.SC_UNAUTHORIZED, checkResult.getDescription());
            return false;
        }
        return true;
    }
}
