package ru.yandex.travel.infrastructure;

import io.opentracing.Tracer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.travel.commons.retry.Retry;

@Configuration
public class RetryHelperAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(Retry.class)
    public Retry retryHelper(Tracer tracer) {
        return new Retry(tracer);
    }
}
