package ru.yandex.travel.ping;

import java.time.Duration;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value = "ping-controller", ignoreUnknownFields = false)
@Data
public class PingControllerProperties {
    private Duration balancerPingPeriodForNanny;
    private Duration balancerPingPeriodForAlert;
    private Duration healthUpDelay;
    private Duration decreasedWeightDuration;
    private String decreasedWeightHeaderValue = "0.1";
    private String normalWeightHeaderValue = "1";
}
