package ru.yandex.travel.tracing;

import java.util.Iterator;
import java.util.Map;

import io.grpc.Metadata;
import io.opentracing.propagation.TextMap;

public class GrpcMetadataInjectAdapter implements TextMap {
    private final Metadata headers;

    public GrpcMetadataInjectAdapter(Metadata headers) {
        this.headers = headers;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        throw new UnsupportedOperationException("This class should be used only with Tracer.inject()!");
    }

    @Override
    public void put(String key, String value) {
        headers.put(Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER), value);
    }
}
