package ru.yandex.travel.tracing;

import java.util.function.Function;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;

public class TracerHelpers {
    private TracerHelpers() {}

    public static <T, U> Function<T, U> applyWithActiveSpanScope(Tracer tracer, Span span, Function<T, U> fn) {
        return arg -> {
            try (Scope scope = tracer.activateSpan(span)) {
                return fn.apply(arg);
            }
        };
    }
}
