package ru.yandex.travel.tvm;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(TvmDefaultProperties.class)
@ConditionalOnProperty(value = "tvm.enabled")
@ConditionalOnMissingBean(TvmWrapper.class)
public class TvmAutoConfiguration {

    @Autowired
    TvmDefaultProperties tvmProperties;

    @Bean
    public TvmWrapper tvm2() {
        return TvmHelper.getTvmWrapper(tvmProperties);
    }
}
