package ru.yandex.travel.utils;

import java.time.Clock;
import java.time.ZoneId;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * Mock-able component for unit-testing simplification.
 */
@AllArgsConstructor(access = AccessLevel.PRIVATE)
@Getter
public class ClockService {
    private final Clock utc;

    public ClockService() {
        this(Clock.systemUTC());
    }

    public static ClockService create(Clock clock) {
        return new ClockService(clock.withZone(ZoneId.of("UTC")));
    }

    public Clock getForZone(ZoneId zoneId) {
        return utc.withZone(zoneId);
    }

    public Clock getForSystemDefaultZone() {
        return getForZone(ZoneId.systemDefault());
    }
}
