package ru.yandex.travel.takeout.models;

import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class AviaTakeoutOrderItem {
    public static final String AVIA_ORDER_ITEM_TYPE = "avia";

    @Builder.Default
    private String type = AVIA_ORDER_ITEM_TYPE;
    private Money price;

    private List<List<AviaTakeoutSegment>> segments;
    private List<AviaTakeoutPassenger> passengers;
    private String pnr;
    private List<String> tickets;

    private String phone;
    private String email;
}
