package ru.yandex.travel.takeout.models;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class HotelTakeoutOrder {
    public static final String HOTEL_ORDER_TYPE = "hotel_order";

    @Builder.Default
    private String type = HOTEL_ORDER_TYPE;
    private String prettyId;
    private Instant createdAt;
    private TakeoutOrderStatus status;
    private Money price;
    private Instant refundedAt;
    private Money refundedSum;

    private String hotelName;
    private String hotelRoomName;
    private LocalDate checkIn;
    private LocalDate checkOut;
    private List<HotelTakeoutGuest> guests;

    private String phone;
    private String email;
}
