package ru.yandex.travel.takeout.models;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class HotelTakeoutOrderItem {
    public static final String HOTEL_ORDER_ITEM_TYPE = "hotel";

    @Builder.Default
    private String type = HOTEL_ORDER_ITEM_TYPE;
    private Money price;
    private Instant refundedAt;
    private Money refundedSum;

    private String hotelName;
    private String hotelRoomName;
    private LocalDate checkIn;
    private LocalDate checkOut;
    private List<HotelTakeoutGuest> guests;

    private String phone;
    private String email;
}
