package ru.yandex.travel.takeout.models;

import java.time.LocalDate;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.javamoney.moneta.Money;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SuburbanTakeoutOrderItem {
    private static final String SUBURBAN_ORDER_ITEM_TYPE = "suburban";

    @Builder.Default
    private String type = SUBURBAN_ORDER_ITEM_TYPE;
    private LocalDate date;
    private String stationFrom;
    private String stationTo;
    private Money price;
    private String ticketNumber;
}
