package ru.yandex.travel.takeout.models;

import java.time.Instant;
import java.util.List;

import lombok.Data;
import org.javamoney.moneta.Money;

@Data
public class TakeoutOrder {
    private String type;
    private TakeoutOrderStatus status;

    private String prettyId;
    private Instant createdAt;

    private Money payAmount;
    private Money refundAmount;

    private List<TrainTakeoutOrderItem> trainItems;
    private List<HotelTakeoutOrderItem> hotelItems;
    private List<AviaTakeoutOrderItem> aviaItems;
    private List<SuburbanTakeoutOrderItem> suburbanItems;
}
