package ru.yandex.travel.takeout.models;

import java.util.Map;

import ru.yandex.travel.orders.commons.proto.EDisplayOrderState;

public enum TakeoutOrderStatus {
    IN_PROGRESS, CANCELLED, CONFIRMED, REFUNDED, UNKNOWN;

    private static Map<EDisplayOrderState, TakeoutOrderStatus> displayStateMap = Map.of(
            EDisplayOrderState.OS_IN_PROGRESS, TakeoutOrderStatus.IN_PROGRESS,
            EDisplayOrderState.OS_AWAITS_PAYMENT, TakeoutOrderStatus.IN_PROGRESS,
            EDisplayOrderState.OS_CANCELLED, TakeoutOrderStatus.CANCELLED,
            EDisplayOrderState.OS_FULFILLED, TakeoutOrderStatus.CONFIRMED,
            EDisplayOrderState.OS_REFUNDED, TakeoutOrderStatus.REFUNDED
    );

    public static TakeoutOrderStatus fromDisplayState(EDisplayOrderState state) {
        return displayStateMap.getOrDefault(state, TakeoutOrderStatus.UNKNOWN);
    }
}
