package ru.yandex.travel.takeout.models;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

@Data
public class TakeoutResponse {
    private Instant finishedAt;
    private String error;
    private List<TrainOrder> trainOrders;
    private List<AviaTakeoutOrder> aviaOrders;
    private List<HotelTakeoutOrder> hotelOrders;
    private List<TakeoutOrder> genericOrders;

    @JsonIgnore
    public boolean isEmpty() {
        return (trainOrders == null || trainOrders.isEmpty()) &&
                (aviaOrders == null || aviaOrders.isEmpty()) &&
                (hotelOrders == null || hotelOrders.isEmpty()) &&
                (genericOrders == null || genericOrders.isEmpty());
    }
}
