package ru.yandex.travel.takeout.models;

import java.time.Instant;
import java.util.List;

import lombok.Data;
import org.javamoney.moneta.Money;

import ru.yandex.travel.train.model.CarType;

@Data
public class TrainOrder {
    public static final String TRAIN_ORDER_TYPE = "train_order";

    private String type = TRAIN_ORDER_TYPE;
    private TakeoutOrderStatus status;

    private String trainNumber;
    private String carNumber;
    private CarType carType;
    private String departureStation;
    private String arrivalStation;
    private Instant departureTime;
    private Instant arrivalTime;

    private String reservationNumber;
    private Money payAmount;
    private Money feeAmount;
    private Money refundAmount;
    private List<TrainOrderPassenger> passengers;
}
