package ru.yandex.travel.task_processor;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import lombok.RequiredArgsConstructor;


@RequiredArgsConstructor
public class RegularTaskKeyProvider<K extends Comparable<K>> extends AbstractTaskKeyProvider<K> {

    private final K key;

    @Override
    public Collection<K> getPendingTaskKeys(int maxResultSize) {
        if (getLockedTaskKeys().contains(key)) {
            return List.of();
        }
        return Collections.singletonList(key);
    }

    @Override
    public long getPendingTasksCount() {
        return 1;
    }
}
