package ru.yandex.travel.task_processor;

import java.util.Collection;

public interface TaskKeyProvider<K> {
    Collection<K> getPendingTaskKeys(int maxResultSize);

    // Those two methods are used to share information on currently active tasks between task processor and provider.
    boolean acquireTaskLock(K taskKey);

    void releaseTaskLock(K taskKey);

    long getPendingTasksCount();
}
