package ru.yandex.travel.task_processor;

import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import ru.yandex.travel.spring.tx.ForcedRollbackTxManagerWrapper;

public class TaskProcessorHelper {
    public static TransactionDefinition createDefaultTxDefinition(String definitionName) {
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        transactionDefinition.setName(definitionName);
        transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        transactionDefinition.setIsolationLevel(TransactionDefinition.ISOLATION_REPEATABLE_READ);
        return transactionDefinition;
    }

    public static <T extends Comparable<T>> TaskKeyProvider<T> createTaskKeyProvider(
            BiFunction<Set<T>, Integer, Collection<T>> pendingTaskKeysLoader,
            Function<Set<T>, Long> pendingTasksCounter
    ) {
        return new AbstractTaskKeyProvider<>() {
            @Override
            public Collection<T> getPendingTaskKeys(int maxResultSize) {
                return pendingTaskKeysLoader.apply(getLockedTaskKeys(), maxResultSize);
            }

            @Override
            public long getPendingTasksCount() {
                return pendingTasksCounter.apply(getLockedTaskKeys());
            }
        };
    }

    public static <T extends Comparable<T>> TaskProcessor<T> simpleTaskProcessor(
            AbstractSimpleTask<T> simpleTask,
            ForcedRollbackTxManagerWrapper forcedRollbackTxManagerWrapper,
            TaskProcessorProperties properties
    ) {
        TransactionDefinition txDefinition = createDefaultTxDefinition(properties.getName() + "TxDef");
        return new TaskProcessor<>(simpleTask, simpleTask, forcedRollbackTxManagerWrapper, txDefinition, properties);
    }
}
