package ru.yandex.travel.task_processor;

import java.time.Duration;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.validation.annotation.Validated;

@Validated
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder(toBuilder = true)
public class TaskProcessorProperties {
    @NotEmpty
    private String name;
    @NotNull
    private Duration initialStartDelay;
    @NotNull
    private Duration scheduleRate;
    @NotNull
    @Min(0)
    private Integer poolSize;
    private boolean daemonPoolThreads;
    private boolean gracefulPoolShutdown;
    private Duration poolShutdownWaitDuration;
    @Builder.Default
    private boolean enabled = true;
}
