package ru.yandex.travel.orders.services.payments;

import java.util.concurrent.CompletableFuture;

import ru.yandex.travel.orders.services.payments.model.TrustBasketStatusResponse;
import ru.yandex.travel.orders.services.payments.model.TrustClearResponse;
import ru.yandex.travel.orders.services.payments.model.TrustCreateBasketRequest;
import ru.yandex.travel.orders.services.payments.model.TrustCreateBasketResponse;
import ru.yandex.travel.orders.services.payments.model.TrustCreateOrderResponse;
import ru.yandex.travel.orders.services.payments.model.TrustCreateRefundRequest;
import ru.yandex.travel.orders.services.payments.model.TrustCreateRefundResponse;
import ru.yandex.travel.orders.services.payments.model.TrustPaymentMethodsResponse;
import ru.yandex.travel.orders.services.payments.model.TrustPaymentReceiptResponse;
import ru.yandex.travel.orders.services.payments.model.TrustRefundStatusResponse;
import ru.yandex.travel.orders.services.payments.model.TrustResizeRequest;
import ru.yandex.travel.orders.services.payments.model.TrustResizeResponse;
import ru.yandex.travel.orders.services.payments.model.TrustStartPaymentResponse;
import ru.yandex.travel.orders.services.payments.model.TrustStartRefundResponse;
import ru.yandex.travel.orders.services.payments.model.TrustUnholdResponse;
import ru.yandex.travel.orders.services.payments.model.plus.TrustCreateAccountRequest;
import ru.yandex.travel.orders.services.payments.model.plus.TrustCreateAccountResponse;
import ru.yandex.travel.orders.services.payments.model.plus.TrustCreateTopupResponse;
import ru.yandex.travel.orders.services.payments.model.plus.TrustTopupRequest;
import ru.yandex.travel.orders.services.payments.model.plus.TrustTopupStartResponse;
import ru.yandex.travel.orders.services.payments.model.plus.TrustTopupStatusResponse;

public interface TrustClient {
    TrustCreateOrderResponse createOrder(String productId, TrustUserInfo userInfo);

    TrustCreateBasketResponse createBasket(TrustCreateBasketRequest request, TrustUserInfo userInfo, Object testContext);

    TrustBasketStatusResponse getBasketStatus(String purchaseToken, TrustUserInfo userInfo);

    TrustStartPaymentResponse startPayment(String purchaseToken, TrustUserInfo userInfo);

    TrustClearResponse clear(String purchaseToken, TrustUserInfo userInfo);

    TrustUnholdResponse unhold(String purchaseToken, TrustUserInfo userInfo);

    TrustResizeResponse resize(String purchaseToken, String orderId, TrustResizeRequest resizeRequest,
                               TrustUserInfo userInfo);

    TrustCreateRefundResponse createRefund(TrustCreateRefundRequest request, TrustUserInfo userInfo);

    TrustStartRefundResponse startRefund(String refundId, TrustUserInfo userInfo);

    TrustRefundStatusResponse getRefundStatus(String refundId, TrustUserInfo userInfo);

    TrustPaymentReceiptResponse getReceipt(String purchaseToken, String receiptId, TrustUserInfo userInfo);

    default TrustPaymentReceiptResponse getReceipt(String purchaseToken, TrustUserInfo userInfo) {
        // receiptId == purchaseToken for main receipt
        return getReceipt(purchaseToken, purchaseToken, userInfo);
    }

    TrustPaymentMethodsResponse getPaymentMethods(TrustUserInfo userInfo);

    CompletableFuture<TrustPaymentMethodsResponse> getPaymentMethodsAsync(TrustUserInfo userInfo);

    // ===== YANDEX PLUS METHODS ======

    TrustCreateAccountResponse createAccount(TrustCreateAccountRequest request, TrustUserInfo userInfo);

    /**
     * Заводит новую заявку на выплату средств на аккаунт пользователя.
     * */
    TrustCreateTopupResponse createTopup(TrustTopupRequest request, TrustUserInfo userInfo);

    /**
     * Возвращает статус заявки на выплату средств на аккаунт пользователя
     */
    TrustTopupStatusResponse getTopupStatus(String purchaseToken, TrustUserInfo userInfo);

    /**
     * Запускает заявку на выполнение
     */
    TrustTopupStartResponse startTopup(String purchaseToken, TrustUserInfo userInfo);

}
