package ru.yandex.travel.orders.services.payments;

import java.time.Duration;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value = "trust", ignoreUnknownFields = false)
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Getter
@Setter
@Validated
public class TrustConnectionProperties {
    @NotEmpty
    private String baseUrl;
    @Deprecated
    private boolean forceRetry400;

    @NotNull
    private Duration httpReadTimeout;
    @NotNull
    private Duration httpRequestTimeout;
}
