package ru.yandex.travel.orders.services.payments.model;

import java.text.MessageFormat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PaymentStatusEnum {
    NOT_STARTED("not_started"),
    STARTED("started"),
    AUTHORIZED("authorized"),
    NOT_AUTHORIZED("not_authorized"),
    THREEDS_STARTED("3ds_started"),
    CLEARED("cleared"),
    CANCELED("canceled"),
    REFUNDED("refunded");

    private final String value;

    PaymentStatusEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static PaymentStatusEnum fromString(String value) {
        for (PaymentStatusEnum candidate : PaymentStatusEnum.values()) {
            if (candidate.value.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("Couldn''t find enum of type {0} for string {1}", PaymentStatusEnum.class, value));
    }
}
