package ru.yandex.travel.orders.services.payments.model;

import java.time.Instant;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustBasketStatusResponse {
    private String trustPaymentId;
    private TrustResponseStatus status;
    private String paymentRespCode;
    private String paymentRespDesc;
    private PaymentStatusEnum paymentStatus;
    private String purchaseToken;
    private Double amount;
    private String currency;
    private String paymentTimeout;
    private String fiscalReceiptUrl;
    private String fiscalReceiptClearingUrl;
    private String reversalId;
    private List<TrustStatusRefundInfo> refunds;
    private List<TrustBasketStatusResponseOrder> orders;
    // Map<orderId, orderMarkup>
    private Map<String, TrustCompositeOrderPaymentMarkup> paymentMarkup;
    private Instant startTs;
    private Instant updateTs;
    private Instant paymentTs;
    private Instant paysysSentTs;
    private Instant unholdRealTs;
    private Instant finalStatusTs;
    private Instant unholdTs;
    private Instant cancelTs;
    private Instant clearTs;
    private Instant clearRealTs;

    private String rrn;
    private String userAccount;
    private String approvalCode;
    private List<String> boundTo;

    private TrustBindingToken bindingToken;
    private String cardType;
    private String paymentMethod;
    private String paymethodId;

    private TrustTerminal terminal;
    private TrustTerminal primaryTerminal;
}
