package ru.yandex.travel.orders.services.payments.model;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;

@Value
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustBoundPaymentMethod {
    private Integer regionId;
    private TrustBoundPaymentMethodType paymentMethod;
    private Integer expirationMonth;
    private Instant bindingTs;
    private String id;
    private List<String> aliases;
    private Boolean expired;
    private String cardBank;
    private String system;
    private String recommendedVerificationType;
    private String origUid;
    private String cardCountry;
    private String paymentSystem;
    private String cardLevel;
    private String holder;
    private List<String> bindingSystems;
    private String account;
    private Integer expirationYear;
    private String cardId;
    private List<String> ebinTags;
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal balance;
    private String currency;
}
