package ru.yandex.travel.orders.services.payments.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
public enum TrustBoundPaymentMethodType implements ValueBasedEnum<String> {
    PHONE("phone"),
    YANDEX_MONEY("yandex_money"),
    YANDEX_ACCOUNT("yandex_account"),
    CARD("card");

    private static final EnumIndex<String, TrustBoundPaymentMethodType> index =
            EnumIndex.create(TrustBoundPaymentMethodType.class);

    private final String value;

    @JsonCreator
    public static TrustBoundPaymentMethodType forValue(String value) {
        return index.getByValue(value);
    }

    @JsonValue
    public String getValue() {
        return value;
    }
}
