package ru.yandex.travel.orders.services.payments.model;

import java.util.List;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import ru.yandex.travel.commons.logging.masking.PersonalData;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class TrustCreateBasketRequest {
    private String paymethodId;
    private String token;
    private String productId;
    private String amount;
    private String uid;
    private String currency;
    private String backUrl;
    private String returnPath;
    private Double paymentTimeout;
    private String acceptPromo;
    private String discounts;
    private String waitForCvn;
    private String lang;
    private String templateTag;
    private String domainSfx;
    private String paymentMode;
    private String fiscalTaxationType;
    private String fiscalPartnerInn;
    private String fiscalNds;
    private String fiscalTitle;
    private String keepToken;
    @PersonalData
    private String userEmail;
    @PersonalData
    private String userPhone;
    private String isExternalBinding;
    private List<TrustCreateBasketOrder> orders;
    // Map<orderId, orderMarkup>
    private Map<String, TrustCompositeOrderPaymentMarkup> paymethodMarkup;
    private TrustCreateBasketPassParams passParams;
    private TrustCreateBasketAfsParams afsParams;
    private String developerPayload;
}
