package ru.yandex.travel.orders.services.payments.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustCreateRefundRequest {

    private String reasonDesc;
    @Getter(AccessLevel.NONE)
    private List<Order> orders;
    // Map<orderId, orderMarkup>; actually means refund markup, should sums up to the total specified orders sum
    private Map<String, TrustCompositeOrderPaymentMarkup> paymethodMarkup;
    private String purchaseToken;

    public List<Order> getOrders() {
        if (orders == null) {
            orders = new ArrayList<>();
        }
        return orders;
    }

    public void addOrder(String orderId, BigDecimal amount) {
        if (orders == null) {
            orders = new ArrayList<>();
        }
        Order order = new Order();
        order.setOrderId(orderId);
        order.setDeltaAmount(amount);
        orders.add(order);
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    public static class Order {
        private String orderId;
        @JsonSerialize(using = AmountSerializer.class)
        private BigDecimal deltaAmount;
    }
}
