package ru.yandex.travel.orders.services.payments.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

@Data
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustEnabledPaymentMethod {
    // todo(tlg-13): find out if we can use Enum here (or add a safe enum getter)
    private String paymentMethod;
    private String currency;
    private Long firmId;
    private List<String> paymentSystems;

    public TrustEnabledPaymentMethodType getPaymentMethodEnum() {
        return TrustEnabledPaymentMethodType.forValueSafe(paymentMethod);
    }
}
