package ru.yandex.travel.orders.services.payments.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@AllArgsConstructor
@Getter
public enum TrustEnabledPaymentMethodType implements ValueBasedEnum<String> {
    APPLE_PAY("apple_pay"),
    CARD("card"),
    COMPENSATION("compensation"),
    COMPOSITE("composite"),
    YANDEX_ACCOUNT_TOPUP("yandex_account_topup"),
    YANDEX_ACCOUNT_WITHDRAW("yandex_account_withdraw"),

    // doesn't actually exist in the partner API
    UNKNOWN("___UNKNOWN_ENABLED_PAYMENT_METHOD___");

    private static final EnumIndex<String, TrustEnabledPaymentMethodType> index =
            EnumIndex.create(TrustEnabledPaymentMethodType.class);

    @JsonValue
    private final String value;

    @JsonCreator
    public static TrustEnabledPaymentMethodType forValue(String value) {
        return index.getByValue(value);
    }

    public static TrustEnabledPaymentMethodType forValueSafe(String value) {
        return index.getByValueOrDefault(value, UNKNOWN);
    }
}
