package ru.yandex.travel.orders.services.payments.model;

import java.time.Instant;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;

@Value
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public final class TrustOrderStatusResponse {
    private final TrustResponseStatus status;
    private final String orderId;
    private final String uid;
    private final Instant orderTs;
    private final Double currentQty;
    private final List<List<String>> currentAmount;
    private final String productType;
    private final String productName;
    private final String productId;
}
