package ru.yandex.travel.orders.services.payments.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Builder;
import lombok.Data;
import lombok.extern.jackson.Jacksonized;

/**
 * Check the docs for more information:
 * https://wiki.yandex-team.ru/TRUST/Payments/API/PaymentMethods/#formatzaprosa
 */
@Data
@Builder
@Jacksonized
@JsonInclude(JsonInclude.Include.NON_NULL)
public class TrustPaymentMethodsRequest {
    private Boolean showPlates;
    private Boolean showEnabled;
    private Boolean showBound;
    private String paymentMethod;
    private String processing;
    private String currency;
    private Long firmId;
    private Boolean showTrustPaymentId;
    private Boolean withVerificationDetails;
}
