package ru.yandex.travel.orders.services.payments.model;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

import javax.money.CurrencyUnit;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Builder;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;

@Value
@Builder
@Jacksonized
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustPaymentMethodsResponse {
    private TrustResponseStatus status;
    private List<TrustBoundPaymentMethod> boundPaymentMethods;
    private List<TrustEnabledPaymentMethod> enabledPaymentMethods;

    public List<TrustBoundPaymentMethod> getBoundPaymentMethods() {
        return Objects.requireNonNullElse(boundPaymentMethods, Collections.emptyList());
    }

    public List<TrustEnabledPaymentMethod> getEnabledPaymentMethods() {
        return Objects.requireNonNullElse(enabledPaymentMethods, Collections.emptyList());
    }

    public TrustBoundPaymentMethod getBoundYandexAccountMethod(CurrencyUnit currency) {
        // there shouldn't be multiple accounts with the same currency but the document that states it
        // has an example when it happens, in this case we will use the account with most points
        // (https://wiki.yandex-team.ru/trust/yandexaccount/#sozdanienovogobonusnogoakkaunta)
        return getBoundPaymentMethods().stream()
                .filter(m -> m.getPaymentMethod() == TrustBoundPaymentMethodType.YANDEX_ACCOUNT)
                .filter(m -> currency.getCurrencyCode().equals(m.getCurrency()))
                .max(Comparator.comparing(m -> Objects.requireNonNullElse(m.getBalance(), BigDecimal.ZERO)))
                .orElse(null);
    }
}
