package ru.yandex.travel.orders.services.payments.model;

import java.text.MessageFormat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum TrustRefundState {
    SUCCESS("success"),
    ERROR("error"),
    FAILED("failed"),
    WAIT_FOR_NOTIFICATION("wait_for_notification");


    private String trustState;

    TrustRefundState(String trustState) {
        this.trustState = trustState;
    }

    @JsonCreator
    public static TrustRefundState fromString(String value) {
        for (TrustRefundState candidate : TrustRefundState.values()) {
            if (candidate.trustState.equals(value)) {
                return candidate;
            }
        }
        throw new IllegalArgumentException(
                MessageFormat.format(
                        "Could not find enum of type {0} for string {1}", TrustRefundState.class, value)
        );
    }

    public String getValue() {
        return trustState;
    }

    @JsonValue
    public String getTrustState() {
        return trustState;
    }
}
