package ru.yandex.travel.orders.services.payments.model;

import java.math.BigDecimal;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class TrustResizeRequest {
    @JsonSerialize(using = AmountSerializer.class)
    BigDecimal amount;
    Integer qty;
    // Map<orderId, orderMarkup> with only this order's id specified
    Map<String, TrustCompositeOrderPaymentMarkup> paymethodMarkup;
}
