package ru.yandex.travel.orders.services.payments.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@RequiredArgsConstructor
@Getter
public enum TrustResponseStatus implements ValueBasedEnum<String> {
    SUCCESS("success"),
    NO_AUTH("no_auth"),
    WAIT_FOR_NOTIFICATION("wait_for_notification"), // only seen when refund is started
    ERROR("error");

    public static final EnumIndex<String, TrustResponseStatus> index = EnumIndex.create(TrustResponseStatus.class);

    @JsonValue
    private final String value;

    @JsonCreator
    public static TrustResponseStatus fromString(String value) {
        return index.getByValue(value);
    }
}
