package ru.yandex.travel.orders.services.payments.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.Getter;
import lombok.RequiredArgsConstructor;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

/*
Выбор терминала внутри одного сервиса Траста по партнеру
https://st.yandex-team.ru/RASPFRONT-9821
*/
@RequiredArgsConstructor
public enum TrustTerminalForPartner implements ValueBasedEnum<String> {
    MOVISTA("movista"),
    IM("im");

    @Getter
    @JsonValue
    private final String value;

    private static final EnumIndex<String, TrustTerminalForPartner> INDEX = EnumIndex.create(TrustTerminalForPartner.class);

    @JsonCreator
    public static TrustTerminalForPartner forValue(String value) {
        return INDEX.getByValue(value);
    }
}

