package ru.yandex.travel.orders.services.payments.model.plus;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import lombok.AllArgsConstructor;
import lombok.Getter;

import ru.yandex.travel.commons.enums.EnumIndex;
import ru.yandex.travel.commons.enums.ValueBasedEnum;

@AllArgsConstructor
@Getter
public enum TrustTopupCashbackType implements ValueBasedEnum<String> {
    TRANSACTION("transaction"),
    AGENT("agent"),
    NON_TRANSACTION("nontransaction");

    private static final EnumIndex<String, TrustTopupCashbackType> index =
            EnumIndex.create(TrustTopupCashbackType.class);

    @JsonValue
    private final String value;

    @JsonCreator
    public static TrustTopupCashbackType forValue(String value) {
        return index.getByValue(value);
    }
}
