package ru.yandex.travel.orders.services.payments.model.plus;

import java.math.BigDecimal;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Builder;
import lombok.Value;
import lombok.extern.jackson.Jacksonized;

import ru.yandex.travel.commons.jackson.BigDecimalConverters;
import ru.yandex.travel.commons.jackson.BooleanConverters;

/**
 * More info on travel payload format here:
 * https://st.yandex-team.ru/TRAVELBACK-2590
 */
@Value
@Builder
@Jacksonized
public class TrustTopupPayload {
    //код сервиса внутри юр. лица биллинга.
    private final String cashbackService;
    //тип баллов
    private final TrustTopupCashbackType cashbackType;
    //признак плюсовика или неплюсовика на дату транзакции
    @JsonSerialize(converter = BooleanConverters.ToString.class)
    @JsonDeserialize(converter = BooleanConverters.FromString.class)
    private final Boolean hasPlus;
    //сумма оборотов, GMV c НДС
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @JsonSerialize(converter = BigDecimalConverters.ToPlainString.class)
    private final BigDecimal baseAmount;
    //сумма комиссии (сервисного сбора)
    @JsonSerialize(converter = BigDecimalConverters.ToPlainString.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final BigDecimal commissionAmount;
    //сумма НДС комиссии, если нет то берем 20%
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @JsonSerialize(converter = BigDecimalConverters.ToPlainString.class)
    private final BigDecimal vatCommissionAmount;
    //платежный сервис (станция), который передается в трасте при начислении баллов
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private final Long serviceId;
    //кто выпускает. Если выпускается в рамках акции.
    private final String issuer;
    //в рамках какой акции/компании. Если выпускается в рамках акции.
    private final String campaignName;
    //номер тикета в котором согласовывался выпуск баллов
    private final String ticket;
    //Код страны совершения транзакции
    private final String country;
    //Валюта страны совершения транзакции
    private final String currency;
}
